package gov.va.vinci.dart.json.builder;

import java.text.SimpleDateFormat;

import gov.va.vinci.dart.biz.RequestLocationDocumentSummary;
import gov.va.vinci.dart.biz.RequestParticipantDocumentSummary;
import gov.va.vinci.dart.json.DocumentReviewNoteView;

public class DocumentReviewNoteViewBuilder {
	public static final SimpleDateFormat LONG_FORMAT_SDF = new SimpleDateFormat("MM/dd/yy hh:mmaa");

	public DocumentReviewNoteView build(final RequestLocationDocumentSummary summary) {
		DocumentReviewNoteView result = new DocumentReviewNoteView();
		
		result.setDocumentId(summary.getDocumentId());
		result.setCreated(summary.getReviewNoteCreatedOn()==null?null:LONG_FORMAT_SDF.format(summary.getReviewNoteCreatedOn()));
		result.setNote(summary.getReviewNote());
		result.setCreatedBy(summary.getCreatedBy());
				
		return result;
	}
	
	public DocumentReviewNoteView build(final RequestParticipantDocumentSummary summary) {
		DocumentReviewNoteView result = new DocumentReviewNoteView();
		
		result.setDocumentId(summary.getDocumentId());
		result.setCreated(summary.getReviewNoteCreatedOn()==null?null:LONG_FORMAT_SDF.format(summary.getReviewNoteCreatedOn()));
		result.setNote(summary.getReviewNote());
		result.setCreatedBy(summary.getCreatedBy());
		
		return result;
	}

}
